//#include "..\QIPGRAPH\QIPGraph.h"
#include "C:\Program Files\QIPGraph\QIPGraph.h"
#include <vector>

using namespace QIPGRAPH;

int main()
{

	// create instance
	bool persist = false;           // gnuplot does not persists after end of program
	int width = 300;                // width of the plot window
	int heigh = 200;                // width of the plot window 
	Plot plot(persist,width,heigh); // get an instance of gnuplot

	// plot function
	plot.command("p cos(x)" );

	// create data, 3 columns
	std::vector<double> vec_x, vec_y, vec_z;
	vec_x.push_back(-1.); vec_x.push_back(2.); vec_x.push_back(3.);
	vec_y.push_back(1.3); vec_y.push_back(2.); vec_y.push_back(1.);
	vec_z.push_back(2.3); vec_z.push_back(1.); vec_z.push_back(0.5);

	// send data directly to gnuplot
	// plot 2 curves in the same figure
	plot.command("p [-2:4] '-' w lp, '' w lp" );
	plot.plot_Vectors("",vec_x, vec_y);
	plot.plot_Vectors("",vec_x, vec_z);

	// change dir, need special command to update current dir in Plot class 
	//plot.command_cd(" cd 'C:\\Documents and Settings\\dami\\My Documents'");

	// save to a file first
	plot.plot_Vectors("data4.dat",vec_x, vec_y, vec_z);

	// plot from file
	plot.command("p 'data4.dat' u 1:2 w lp t 'y','' u 1:3 w l t 'z'" );

	// plot arrow using the mouse
	// click on the initial position, push 5 to store the position
	// click on the final   position, push 5 to store the position
	int number = 1;                // number of the arrow
	plot.command_arrow(number);

	// plot arrow giving positions (from, to) = (0,1.1) to (2,1.8)
	std::string style = "";
	number = 2;
	plot.command_arrow(number,style.c_str(),0,1.1,2,1.8);

	// plot label using the mouse
	// click on the position, push 5 to store the position
	number = 1;
	style = "";
	plot.command_label("1st" ,number, style.c_str());

	// plot label giving coordinates: (2,1.8)
	number = 2;
	style = "";
	plot.command_label("2nd" ,2,style.c_str(),2,1.5);

	// obtain MOUSE_X variable (last click)
	double MOUSE_X = plot.get_value_double("MOUSE_X");

	// obtain a vector of values
	std::vector<const char*> vecMouseVar;
	vecMouseVar.push_back("MOUSE_X");
	vecMouseVar.push_back("MOUSE_Y");
	vecMouseVar.push_back("MOUSE_X2");   
	vecMouseVar.push_back("MOUSE_Y2");   
	vecMouseVar.push_back("TOTO");     // not present   
	std::vector<double> vecMouse = plot.get_value_double(vecMouseVar);
	// result = { MOUSE_X, MOUSE_Y, MOUSE_X2, MOUSE_Y2, NaN_d)	
	
	return 0;
}