#pragma once
#include <stdio.h>
#include <string>
#include <vector>

#ifdef QIPGRAPH_EXPORTS
#define QIPGRAPH_API __declspec(dllexport)
#else
#define QIPGRAPH_API __declspec(dllimport)
#endif

namespace QIPGRAPH
{
	// some return constants
	const int NaN_i = -1234567898;
	const double NaN_d = -1.e-97;
	const std::string NaN_s = "0000";

	// path of the executable and temporary folder if necessary to save
	QIPGRAPH_API void set_path_exe(const std::string& path_exe_);
	QIPGRAPH_API std::string get_path_exe();
	QIPGRAPH_API void set_path_temp(const std::string& path_exe_);
	QIPGRAPH_API std::string get_path_temp();	
	QIPGRAPH_API int get_version();	

	// only class
	class QIPGRAPH_API Plot 
	{
			FILE* m_gnu;
			static 	int initialization_var;
			bool m_persist;
			std::string current_dir;

		public:
			FILE* get_FILE() { return m_gnu; }
			FILE* get_FILE_OPEN(const char* filename_ = 0); 
			std::string get_current_dir();	
			void set_current_dir();	

			Plot(const bool& keep_ = false, const int& width_ = 300, const int& height_ = 200) ;
			~Plot();

			// command
			Plot& command(const char* command_);
			Plot& command_cd(const char* command_);
			Plot& command_arrow(const int& n_=-1, const char* style_="",const double& xFrom=NaN_d, const double& yFrom=NaN_d, const double& xTo=NaN_d, const double& yTo=NaN_d);
			Plot& command_label(const char* label_, const int& n_=-1, const char* style_="",const double& xFrom=NaN_d, const double& yFrom=NaN_d );

			// send vectors
			Plot& plot_Vectors(const char* filename_,
				  const std::vector<double>& vec1_
				, const std::vector<double>& vec2_ = std::vector<double>()
				, const std::vector<double>& vec3_ = std::vector<double>()
				, const std::vector<double>& vec4_ = std::vector<double>()
				, const std::vector<double>& vec5_ = std::vector<double>()
				, const std::vector<double>& vec6_ = std::vector<double>()
			);

			// bidirectional, avoid using for Windows
			std::string get_value_string(const char* variable_, const char* type_ = "s");
			std::vector<std::string> get_value_string(const std::vector<const char*>& variables_, const char* type_ = "s");

			double get_value_double(const char* variable_);
			std::vector<double> get_value_double(const std::vector<const char*>& variables_);


	};

}